@echo off
setlocal enabledelayedexpansion
chcp 65001 >nul
echo 准备卸载 "SteganographerGUI"...
echo.

REM --- Step 1: Call the existing registry cleanup script ---
echo 正在清理右键菜单注册表项...
call "%~dp0\02-解除隐写者右键菜单安装.bat"
echo.

REM --- Step 2: Ask if user wants to keep logs ---
set "KEEP_LOGS=N"
set /p "KEEP_LOGS=是否保留日志文件夹 (logs)? [Y/N] (默认: N): "

set "PROGRAM_DIR=%~dp0"
set "TEMP_LOGS=%TEMP%\SteganographerGUI_logs_%RANDOM%"

REM Convert to uppercase and check
if /i "%KEEP_LOGS%"=="Y" (
    set "KEEP_LOGS=Y"
    echo 将保留日志文件夹...
    
    REM Check if logs folder exists
    if exist "%~dp0logs\" (
        echo 正在备份日志到临时目录...
        
        REM Copy logs to temp
        xcopy "%~dp0logs" "%TEMP_LOGS%\" /E /I /H /Y >nul 2>&1
        if errorlevel 1 (
            echo 警告: 日志备份失败，将不保留日志
            set "KEEP_LOGS=N"
        ) else (
            echo 日志已备份，卸载后将恢复
        )
    ) else (
        echo 未找到 logs 文件夹，无需备份
        set "KEEP_LOGS=N"
    )
) else (
    echo 将删除所有文件包括日志...
)
echo.

REM --- Step 3: Prepare for self-deletion ---
set "TEMP_SCRIPT=%TEMP%\temp_uninstall_%RANDOM%.bat"
(
echo @echo off
echo chcp 65001 ^>nul
echo echo 正在删除程序文件...
echo.
echo timeout /t 2 /nobreak ^> nul
echo.
echo rd /s /q "%PROGRAM_DIR%"
echo.
) > "%TEMP_SCRIPT%"

REM If keeping logs, restore them
if /i "%KEEP_LOGS%"=="Y" (
    (
    echo echo.
    echo echo 正在恢复日志文件夹...
    echo if exist "%TEMP_LOGS%\" ^(
    echo     mkdir "%PROGRAM_DIR%" 2^>nul
    echo     xcopy "%TEMP_LOGS%" "%PROGRAM_DIR%logs\" /E /I /H /Y ^>nul
    echo     if errorlevel 1 ^(
    echo         echo 错误: 日志恢复失败！
    echo         echo 日志备份位置: %TEMP_LOGS%
    echo     ^) else ^(
    echo         echo 日志已恢复到: %PROGRAM_DIR%logs
    echo         rd /s /q "%TEMP_LOGS%" 2^>nul
    echo     ^)
    echo ^) else ^(
    echo     echo 警告: 未找到日志备份！
    echo ^)
    ) >> "%TEMP_SCRIPT%"
)

(
echo.
echo echo.
echo echo 卸载完成！按任意键关闭此窗口...
echo pause ^>nul
echo del "%%~f0"
) >> "%TEMP_SCRIPT%"

echo 正在执行卸载...
echo.

REM --- Step 4: Start the temporary script and exit ---
start "" cmd /c "%TEMP_SCRIPT%"

REM Exit immediately
exit