param([string]$FilePath)

$hashModifierPath = Join-Path $PSScriptRoot "hash_modifier.exe"

function Show-Notification {
    param ([string]$Title, [string]$Message)
    Add-Type -AssemblyName System.Windows.Forms
    $global:balmsg = New-Object System.Windows.Forms.NotifyIcon
    $path = (Get-Process -id $pid).Path
    $balmsg.Icon = [System.Drawing.Icon]::ExtractAssociatedIcon($path)
    $balmsg.BalloonTipIcon = [System.Windows.Forms.ToolTipIcon]::Info
    $balmsg.BalloonTipText = $Message
    $balmsg.BalloonTipTitle = $Title
    $balmsg.Visible = $true
    $balmsg.ShowBalloonTip(5000)
}

try {
    $logPath = Join-Path $PSScriptRoot "hash_modifier_log.txt"
    $output = & $hashModifierPath $FilePath 2>&1 | Out-String
    $exitCode = $LASTEXITCODE
    $log = "ִʱ: $(Get-Date)`n"
    $log += ": $hashModifierPath $FilePath`n"
    $log += "˳: $exitCode`n"
    $log += ":`n$output`n"
    $log += "--------------------------------------------------`n"
    $log | Out-File -Append -FilePath $logPath
    if ($exitCode -eq 0 -and $output -match "Modified file hash^|Hash modification completed") {
        Show-Notification -Title "ϣֵ޸" -Message "ѳɹɡļϣֵ޸ġ"
    } else {
        Show-Notification -Title "ϣֵ޸" -Message "δɹɡ־ļ˽顣"
    }
} catch {
    $errorMessage = $_.Exception.Message
    Show-Notification -Title "ϣֵ޸" -Message "ϸϢѼ¼־ļ"
    ": $errorMessage" | Out-File -Append -FilePath $logPath
}
